/****************************************************************************
 **                                                                        **
 **  "(Indendent) Love Bong" - Main intro process - Aron, 1999.02.01.	   **
 **                                                                        **
 ****************************************************************************/

byte mainframebuffer[4*320*200],tempframebuffer[4*320*200],plusframebuffer[4*320*200],
     texturebuffer[TEXTURES_GENERATED*TEXTURE_SIZE],
     blurbuffer[IMAGES_BLURRED*PHASES_BLURRED*BLURBUFFER_SIZE];

char titletext[]= "independent love song{",temptext[64];
char *greetxtext[GREETX_STRINGS]= { "a  s  t  r  o  i  d  e  a",
                                    "c  h  r  o  m  e",
                                    "c  o  d  e  r  } l",
                                    "d  i  l  e  m  m  a",
                                    "d  i  n  a  s  t  y",
                                    "e  x  c  e  e  d",
                                    "e  x  h  u  m  e  r  s",
                                    "e  u  t  h  a  n  a  s  i  a",
                                    "m  a  n  d  u  l  a",
                                    "p  r  o  f  u  s  e",
                                    "r  h  y  m  e",
                                    "u  n  i  t  e  d   f  o  r  c  e",
                                    "{{{",
                                    "w  e   a  d  o  r  e   y  o  u" };

DWORD dwTimer,dwTimerStarted,dwTimeStart;

DWORD dwPartInitialized;
void (*InterpolateFrameBuffer)(byte *);
void (*UpdateScreen)(byte *);

void InitIntro(void)
{
	// texturageneralas es prekalkulacio:
	InitTables();
	InitPolarizator();
	InitTextures(texturebuffer);
	InitBlurer(blurbuffer,SPIN_BLUR);
#ifdef PART_WORMHOLE
	InitWormhole();
#endif
}

int PerformIntro(void)
{
	static CAMERA camera;
	static OMNI_LIGHTSOURCE lightsource;
	static int i,j,k;
	static float t;

	static MIDASplayStatus mpsStatus;

	if(bDDrawInitialized == TRUE)
	{
		// modulpozicio lekerese:
		MIDASgetPlayStatus(hPlaying,&mpsStatus);

		// - intro ------------------------------------------------------------------
		if(mpsStatus.position < 0x04)
		{
			// dobra szinkronizalt blur-olt animaciok:
			if(mpsStatus.position == 0x01) DrawBlurredImage(mainframebuffer,blurbuffer + (7 - dwSyncValue)*BLURBUFFER_SIZE);
			else if(mpsStatus.position == 0x02) DrawBlurredImage(mainframebuffer,blurbuffer + (PHASES_BLURRED + 7 - dwSyncValue)*BLURBUFFER_SIZE);
			else if(mpsStatus.position == 0x03) DrawBlurredImage(mainframebuffer,blurbuffer + + (2*PHASES_BLURRED + 7 - dwSyncValue)*BLURBUFFER_SIZE);
			UpdateScreen(mainframebuffer);
		}
		// - scene: gombok egy reflexiv sik felett ----------------------------------
		else if(mpsStatus.position < 0x08)
		{ 
			// inicializalas:
			if(!(dwPartInitialized & PI_SPHERESSCENE))
			{
				SetupSpheresScene(texturebuffer);
				camera.FOV= 1.0;
				dwTimerStarted= 0;
				dwPartInitialized|= PI_SPHERESSCENE;
			}
			// timer lekerdezese:
			t= (dwTimer - dwTimerStarted)/200.0f;
			// trace-eles ket kameraval:
			if((mpsStatus.position == 0x05) || (mpsStatus.position == 0x07))
			{ 
				camera.position.X= (float)(100.0*sin(0.5*t));
				camera.position.Y= (float)(100.0 + 10.0*t);
				camera.position.Z= (float)(100.0*cos(0.7*t));
				camera.target.X= (float)(15.0*cos(0.7*t));
				camera.target.Y= (float)(10.0 + 8.0*sin(0.9*t));
				camera.target.Z= (float)(15.0*cos(t));
				camera.roll= (float)(M_PI - sin(0.3*t));
			}
			else
			{ 
				camera.position.X= (float)(150.0*sin(2.0*t));
				camera.position.Y= (float)(50.0 + 30.0*sin(1.2*t));
				camera.position.Z= (float)(130.0*cos(2.7*t));
				camera.target.X= (float)(25.0*cos(0.5*t));
				camera.target.Y= (float)(10.0 + 8.0*sin(1.3*t));
				camera.target.Z= (float)(15.0*cos(1.1*t));
				camera.roll= (float)(M_PI + sin(0.4*t));
			}
			lightsource.position.X= (float)(150.0*sin(2.0*t));
			lightsource.position.Y= (float)(90.0 + 25.0*sin(4.0*t));
			lightsource.position.Z= (float)(150.0*cos(2.0*t));
			AnimateSpheresScene(3.0f*t);
			TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
			InterpolateFrameBuffer(mainframebuffer);
			// elejen strobo:
			if((mpsStatus.position == 0x04) && (mpsStatus.row < 17)) HandleStrobo(mainframebuffer,255 - (mpsStatus.row<<4));
			// vegen kifade-eles:
			if(mpsStatus.position == 0x07) FadeFrameBuffer(mainframebuffer,255 - (mpsStatus.row<<2));
			UpdateScreen(mainframebuffer);
		}
		// - logo -------------------------------------------------------------------
		else if(mpsStatus.position < 0x0C)
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_LOGOPART))
			{
				DrawLogo(plusframebuffer + 4*(320*15 + 40));
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_LOGOPART;
			}
			// timer lekerdezese:
			t= (dwTimer - dwTimerStarted)/20.0f;
			// torzitas:
			RecalcTorsionTable((signed int)(-800.0 + 90.0*sin(1.2*t)),(signed int)(700.0 + 90.0*cos(1.4*t)),(signed int)(1250.0 + 90.0*cos(1.3*t)),(signed int)(-750.0 + 90.0*sin(1.1*t)));
			DistortBitmap(mainframebuffer,plusframebuffer);
			// felirat:
			if(mpsStatus.position > 0x08)
			{ 
				if(mpsStatus.position == 0x09)
				{ 
					j= mpsStatus.row;
					if(j < 30)
					{ 
						// "independent love song":
						i= 0;
						while((titletext[i] != '\0') && (i < j)) { temptext[i]= titletext[i]; i++; }
					}
					else if(j < (30 + 4))
					{ 
						// visszatorles, javitas "bong"-ra:
						i= 0;
						while((titletext[i] != '\0') && (i < (17 + 33 - j))) { temptext[i]= titletext[i]; i++; }
						if(j == 33) titletext[17]= 'b';
					}
					else if(j < (30 + 4 + 4))
					{ 
						// ujrairas:
						i= 0;
						while((titletext[i] != '\0') && (i < (17 + j - 34))) { temptext[i]= titletext[i]; i++; }
					}
					else
					{ 
						// teljes kiiras:
						i= 0;
						while((titletext[i] != '\0') && (i < 30)) { temptext[i]= titletext[i]; i++; }
					}
				}
				else
				{ 
					// teljes kiiras:
					i= 0;
					while((titletext[i] != '\0') && (i < 30)) { temptext[i]= titletext[i]; i++; }
				}
				temptext[i]= ' ';
				if((mpsStatus.row & 0x0F) < 8) temptext[i + 1]= '|'; else temptext[i + 1]= ' ';
				temptext[i + 2]= '\0';
				DrawString(temptext,mainframebuffer,20,85,(dword)(230.0 + 25.0*sin(5.0*t)));
			}
			// elejen befade-eles:
			if(mpsStatus.position == 0x08) FadeFrameBuffer(mainframebuffer,mpsStatus.row<<2);
			// vegen kifade-eles:
			if(mpsStatus.position == 0x0B) FadeFrameBuffer(mainframebuffer,255 - (mpsStatus.row<<2));
			UpdateScreen(mainframebuffer);
		}
		// - scene: hullamzo csovek egy gomb belsejeben -----------------------------
		else if(mpsStatus.position < 0x10)
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_PIPESSCENE))
			{
				SetupPipeScene(texturebuffer);
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_PIPESSCENE;
			}
			// timer lekerdezese:
			t= (dwTimer - dwTimerStarted)/100.0f;
			// trace-eles:
			camera.position.X= (float)(200.0*sin(1.2*t));
			camera.position.Y= (float)100.0;
			camera.position.Z= (float)(200.0*cos(1.1*t));
			camera.target.X= (float)(30.0*sin(0.7*t));
			camera.target.Y= (float)0.0;
			camera.target.Z= (float)(30.0*sin(1.5*t));
			camera.roll= (float)(M_PI + 2.0*t);
			lightsource.position.X= (float)(150.0*sin(2.0*t));
			lightsource.position.Y= (float)150.0;
			lightsource.position.Z= (float)(150.0*cos(2.0*t));
			TraceScene(mainframebuffer,&camera,&lightsource,USE_RAY_PERTURBANCE);
			InterpolateFrameBuffer(mainframebuffer);
			// befade-eles:
			if(mpsStatus.position == 0x0C) FadeFrameBuffer(mainframebuffer,mpsStatus.row<<2);    
			UpdateScreen(mainframebuffer);
		}
		// - texturapolarizator -----------------------------------------------------
		else if(mpsStatus.position < 0x14)
		{ 
			// inicializalas:
			if(!(dwPartInitialized & PI_POLARIZATORPART))
			{
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_POLARIZATORPART;
			}
			// timer lekerdezese:
			i= dwTimer - dwTimerStarted; t= i/50.0f;
			// tripla texturapolarizator:
			if((mpsStatus.position == 0x10) || (mpsStatus.position == 0x12))
				PolarizeBitmap(tempframebuffer,
                    (520*(dword)(50 + 50.0*sin(t)) + (dword)(100 + 100*cos(0.8*t)))<<1,
                    (520*(dword)(50 + 50.0*cos(1.7*t)) + (dword)(100 + 100*sin(t)))<<1,
                    (520*(dword)(50 + 50.0*cos(2.3*t)) + (dword)(100 + 100*cos(1.3*t)))<<1,
                    texturebuffer + 1*TEXTURE_SIZE,(byte)(128.0 + 128.0*sin(1.7*t)),
                    i<<1,
                    texturebuffer + 5*TEXTURE_SIZE,(byte)(128.0 + 128.0*cos(1.3*t)),256 - (i<<1));
			else
				PolarizeBitmap(tempframebuffer,
                    (520*(dword)(50 + 50.0*sin(t)) + (dword)(100 + 100*cos(0.8*t)))<<1,
                    (520*(dword)(50 + 50.0*cos(1.7*t)) + (dword)(100 + 100*sin(t)))<<1,
                    (520*(dword)(50 + 50.0*cos(2.3*t)) + (dword)(100 + 100*cos(1.3*t)))<<1,
                    texturebuffer + 0*TEXTURE_SIZE,(byte)(128.0 + 128.0*sin(1.7*t)),
                    i<<1,
                    texturebuffer + 3*TEXTURE_SIZE,(byte)(128.0 + 128.0*cos(1.3*t)),256 - (i<<1));
			DrawSquares(tempframebuffer);
			CopyFrameBuffer(mainframebuffer,tempframebuffer);
			DrawMiniPicture(mainframebuffer + 4*(320*24 + 165),astrospicdata);
			DrawMiniPicture(mainframebuffer + 4*(320*24 + 230),astros2picdata);
			DrawMiniPicture(mainframebuffer + 4*(320*89 + 165),plantpicdata);
			DrawMiniPicture(mainframebuffer + 4*(320*89 + 230),childpicdata);
			// szinkronizalt rangatas:
			if(dwSyncValue)
			{ 
				TwitchFrameBuffer(plusframebuffer,mainframebuffer,dwSyncValue);
				UpdateScreen(plusframebuffer);
			}
			else
			{ 
				// villantas:
				if(mpsStatus.row < 16) BlinkFrameBuffer(mainframebuffer,mpsStatus.row<<4); 
				UpdateScreen(mainframebuffer);
			}
		}
		// - scene: forgo kocka a kozepen reflexiv gombbel --------------------------
		else if(mpsStatus.position < 0x18)
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_CUBESCENE))
			{
				SetupCubeScene(texturebuffer);
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_CUBESCENE;
			}
			// timer lekerdezese:
			t= (dwTimer - dwTimerStarted)/100.0f;
			// trace-eles ket kameraval:
			if((mpsStatus.position == 0x15) || (mpsStatus.position == 0x17))
			{ 
				camera.position.X= (float)(150.0*sin(0.5*t));
				camera.position.Y= (float)(150.0 + 10.0*t);
				camera.position.Z= (float)(150.0*sin(1.3*t));
				camera.target.X= (float)(15.0*cos(0.7*t));
				camera.target.Y= (float)(10.0 + 8.0*sin(0.9*t));
				camera.target.Z= (float)(15.0*cos(t));
				camera.roll= (float)(M_PI - sin(0.5*t));
			}
			else
			{ 
				camera.position.X= (float)(150.0*sin(1.2*t));
				camera.position.Y= (float)(120.0*cos(0.7*t));
				camera.position.Z= (float)(140.0*cos(2*t));
				camera.target.X= (float)(20.0*cos(1.5*t));
				camera.target.Y= (float)(20.0*sin(1.3*t));
				camera.target.Z= (float)(20.0*cos(t));
				camera.roll= (float)M_PI;
			}
			lightsource.position.X= (float)(150.0*sin(2.1*t));
			lightsource.position.Y= (float)(90.0 + 25.0*sin(4.0*t));
			lightsource.position.Z= (float)(150.0*sin(1.3*t));
			AnimateCubeScene(t);
			TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
			InterpolateFrameBuffer(mainframebuffer);
			// elejen strobo:
			if((mpsStatus.position == 0x14) && (mpsStatus.row < 17)) HandleStrobo(mainframebuffer,255 - (mpsStatus.row<<4));
			UpdateScreen(mainframebuffer);
		}
		// - wormhole bump ----------------------------------------------------------
		else if(mpsStatus.position < 0x1C)
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_BUMPPART))
			{
				FillFrameBuffer(plusframebuffer,0x00000000);
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_BUMPPART;
			}
			// timer lekerdezese:
			i= dwTimer - dwTimerStarted; t= i/35.0f;
		    // csikos wormhole bump:
			DrawWormHole(tempframebuffer,texturebuffer + 4*TEXTURE_SIZE,texturebuffer + 3*TEXTURE_SIZE,i>>1);
			DrawBump(mainframebuffer,tempframebuffer,(dword)(50.0 + 40.0*sin(0.7*t)),(dword)(115.0 + 25.0*cos(t)));
			DrawInvertedStripe(mainframebuffer,i>>1);
			// villantas es keret torlese:
			BlinkFrameBuffer(mainframebuffer,(dword)(128.0 + 127.0*sin(t)));
			HideBorders(mainframebuffer);
			// dobra szinkronizalt sztringleptetes:
			k= i/30; if(k > 13) k= 13;
			// greetx szoveg:
			if(k < 7) DrawString(greetxtext[k],mainframebuffer,30,5 + k*25,(dword)(230.0 + 25.0*sin(5.0*t)));
			else DrawString(greetxtext[k],mainframebuffer,30,5 + (k - 7)*25,(dword)(230.0 + 25.0*sin(5.0*t)));
			// elejen strobo:
			if((mpsStatus.position == 0x18) && (mpsStatus.row < 17)) HandleStrobo(mainframebuffer,255 - (mpsStatus.row<<4));
			// vegen szinkronizalva valtas:
			if((mpsStatus.position == 0x1B) && (dwSyncValue == 1)) UpdateScreen(plusframebuffer);
			else UpdateScreen(mainframebuffer);
		}
		// - scene: uveggolyo egy lezart csoben -------------------------------------
		else if(mpsStatus.position < 0x20)
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_MIRRORBALLSCENE))
			{
				SetupMirrorBallScene(texturebuffer);
				dwTimerStarted= dwTimer;
				k= 0;
				dwPartInitialized|= PI_MIRRORBALLSCENE;
			}
			// timer lekerdezese:
			i= dwTimer - dwTimerStarted; t= i/140.0f;
			if(i < 730)
			{ 
				// trace-eles:
				camera.position.X= (float)(200.0*cos(2.0*t));
				camera.position.Y= 0.0f;
				camera.position.Z= (float)(200.0*sin(2.0*t));
				camera.target.X= 0.0f;
				camera.target.Y= 0.0f;
				camera.target.Z= 0.0f;
				camera.roll= (float)(M_PI*cos(t));
				lightsource.position.X= (float)(100.0*sin(2.0*t));
				lightsource.position.Y= 0.0f;
				lightsource.position.Z= (float)(100.0*cos(2.0*t));
				AnimateMirrorBallScene(t);
				TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
				InterpolateFrameBuffer(mainframebuffer);
				// elejen befade-eles:
				if(mpsStatus.position == 0x1C) FadeFrameBuffer(mainframebuffer,mpsStatus.row<<2);
			}
			else
			{ 
				// fekete-feherbe strobo:
				if(k == 0) ConvertMonoFrameBuffer(tempframebuffer,mainframebuffer);
				CopyFrameBuffer(mainframebuffer,tempframebuffer);
				k= (i - 730)<<5;
				if(k) HandleStrobo(mainframebuffer,255 - k);
			}
			UpdateScreen(mainframebuffer);
		}
		// - scene: refraktiv gomb oszlopok kozott ----------------------------------
		else if(mpsStatus.position < 0x22) 
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_COLUMNSSCENE))
			{
				SetupColumnsScene(texturebuffer);
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_COLUMNSSCENE;
			}
			// timer lekerdezese:
			t= (dwTimer - dwTimerStarted)/100.0f;
			// trace-eles:
			camera.position.X= (float)(200.0*cos(1.3*t));
			camera.position.Y= (float)(80.0 + 30.0*sin(0.7*t));
			camera.position.Z= (float)(300.0*sin(1.3*t));
			camera.target.X= (float)(30.0*cos(1.3*t));
			camera.target.Y= (float)(20.0 + 10.0*sin(t));
			camera.target.Z= (float)(30.0*sin(1.7*t));
			camera.roll= (float)(M_PI + 2.0*t);
			lightsource.position.X= (float)(180.0*sin(2.0*t));
			lightsource.position.Y= (float)(80.0 + 30.0*sin(0.6*t));
			lightsource.position.Z= (float)(180.0*cos(1.7*t));
			TraceScene(mainframebuffer,&camera,&lightsource,NOT_USE_RAY_PERTURBANCE);
			InterpolateFrameBuffer(mainframebuffer);
			// elejen strobo:
			if((mpsStatus.position == 0x20) && (mpsStatus.row < 17)) HandleStrobo(mainframebuffer,255 - (mpsStatus.row<<4));
			UpdateScreen(mainframebuffer);
		}
		// - legyszem zoomer es befejezo animacio -----------------------------------
		else if(mpsStatus.position < 0x25) 
		{
			// inicializalas:
			if(!(dwPartInitialized & PI_ENDPART))
			{
				CopyFrameBuffer(plusframebuffer,mainframebuffer);
				dwTimerStarted= dwTimer;
				dwPartInitialized|= PI_ENDPART;
			}
			// timer lekerdezese:
			t= 0.4f + (dwTimer - dwTimerStarted)/1000.0f;
			// csikos legyszem zoomer:
			if(mpsStatus.position < 0x24)
			{ 
				DrawZoomer(mainframebuffer,texturebuffer + 3*TEXTURE_SIZE,t);
				DrawFlyEye(mainframebuffer);
				DrawStripes(mainframebuffer);
				// hatter kifade-elese:
				if(mpsStatus.position == 0x23) FadeFrameBuffer(mainframebuffer,255 - (mpsStatus.row<<2));
				DrawMiniPicture(mainframebuffer + 4*(320*57 + 35),astros2picdata);
				DrawString("c    o    n    t    r    a    c   t",mainframebuffer,24,70,255);
				DrawString("h     u     n     g     a     r     y",mainframebuffer,22,90,255);
				// crossfade-eles:
				if(mpsStatus.position == 0x22) CrossFadeFrameBuffer(mainframebuffer,plusframebuffer,mpsStatus.row<<2);
			}
			else if(mpsStatus.position == 0x24)
			{ 
				DrawBlurredImage(mainframebuffer,blurbuffer + (3*PHASES_BLURRED + (dword)(7.0 - 7.0*fabs(cos(63.4*(t - 0.4))*sin(57.3*(t - 0.4)))))*BLURBUFFER_SIZE);
				if(mpsStatus.position == 0x24) FadeFrameBuffer(mainframebuffer,255 - (mpsStatus.row<<2));
			}
			UpdateScreen(mainframebuffer);
		}
		// vege
		else return FALSE;
	}

	return TRUE;
}
